/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.Cover;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.block.BlockNode;
import com.raoulvdberge.refinedstorage.block.info.BlockInfoBuilder;
import com.raoulvdberge.refinedstorage.block.info.IBlockInfo;
import com.raoulvdberge.refinedstorage.block.property.PropertyObject;
import com.raoulvdberge.refinedstorage.capability.CapabilityNetworkNodeProxy;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.collision.CollisionGroup;
import com.raoulvdberge.refinedstorage.render.constants.ConstantsCable;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelCableCover;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelFullbright;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.TileCable;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.util.CollisionUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCable
extends BlockNode {
    public static final PropertyObject<Cover> COVER_NORTH = new PropertyObject<Cover>("cover_north", Cover.class);
    public static final PropertyObject<Cover> COVER_EAST = new PropertyObject<Cover>("cover_east", Cover.class);
    public static final PropertyObject<Cover> COVER_SOUTH = new PropertyObject<Cover>("cover_south", Cover.class);
    public static final PropertyObject<Cover> COVER_WEST = new PropertyObject<Cover>("cover_west", Cover.class);
    public static final PropertyObject<Cover> COVER_UP = new PropertyObject<Cover>("cover_up", Cover.class);
    public static final PropertyObject<Cover> COVER_DOWN = new PropertyObject<Cover>("cover_down", Cover.class);
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public BlockCable(IBlockInfo info) {
        super(info);
    }

    public BlockCable() {
        super(BlockCable.createBuilder("cable").tileEntity(TileCable::new).create());
    }

    static BlockInfoBuilder createBuilder(String id) {
        return BlockInfoBuilder.forId(id).material(Material.field_151592_s).soundType(SoundType.field_185853_f).hardness(0.35f);
    }

    @SideOnly(value=Side.CLIENT)
    void registerCover(IModelRegistration modelRegistration) {
        modelRegistration.addBakedModelOverride(this.info.getId(), BakedModelCableCover::new);
    }

    @SideOnly(value=Side.CLIENT)
    void registerCoverAndFullbright(IModelRegistration modelRegistration, String ... textures) {
        modelRegistration.addBakedModelOverride(this.info.getId(), base -> new BakedModelCableCover(new BakedModelFullbright((IBakedModel)base, textures)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "down=false,east=true,north=false,south=false,up=false,west=true"));
        this.registerCover(modelRegistration);
    }

    @Override
    public boolean hasConnectedState() {
        return false;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return super.createBlockStateBuilder().add(new IProperty[]{NORTH}).add(new IProperty[]{EAST}).add(new IProperty[]{SOUTH}).add(new IProperty[]{WEST}).add(new IProperty[]{UP}).add(new IProperty[]{DOWN}).add(new IUnlistedProperty[]{COVER_NORTH}).add(new IUnlistedProperty[]{COVER_EAST}).add(new IUnlistedProperty[]{COVER_SOUTH}).add(new IUnlistedProperty[]{COVER_WEST}).add(new IUnlistedProperty[]{COVER_UP}).add(new IUnlistedProperty[]{COVER_DOWN}).build();
    }

    @Override
    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        state = super.func_176221_a(state, world, pos).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(BlockCable.hasConnectionWith(world, pos, this, tile, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(BlockCable.hasConnectionWith(world, pos, this, tile, EnumFacing.EAST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(BlockCable.hasConnectionWith(world, pos, this, tile, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(BlockCable.hasConnectionWith(world, pos, this, tile, EnumFacing.WEST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(BlockCable.hasConnectionWith(world, pos, this, tile, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(BlockCable.hasConnectionWith(world, pos, this, tile, EnumFacing.DOWN)));
        return state;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockState s = super.getExtendedState(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileNode && ((TileNode)tile).getNode() instanceof ICoverable) {
            ICoverable cover = (ICoverable)((Object)((TileNode)tile).getNode());
            s = ((IExtendedBlockState)s).withProperty(COVER_NORTH, (Object)cover.getCoverManager().getCover(EnumFacing.NORTH));
            s = ((IExtendedBlockState)s).withProperty(COVER_EAST, (Object)cover.getCoverManager().getCover(EnumFacing.EAST));
            s = ((IExtendedBlockState)s).withProperty(COVER_SOUTH, (Object)cover.getCoverManager().getCover(EnumFacing.SOUTH));
            s = ((IExtendedBlockState)s).withProperty(COVER_WEST, (Object)cover.getCoverManager().getCover(EnumFacing.WEST));
            s = ((IExtendedBlockState)s).withProperty(COVER_UP, (Object)cover.getCoverManager().getCover(EnumFacing.UP));
            s = ((IExtendedBlockState)s).withProperty(COVER_DOWN, (Object)cover.getCoverManager().getCover(EnumFacing.DOWN));
        }
        return s;
    }

    private static boolean hasConnectionWith(IBlockAccess world, BlockPos pos, BlockBase block, TileEntity tile, EnumFacing direction) {
        Cover cover;
        Cover cover2;
        if (!(tile instanceof TileNode)) {
            return false;
        }
        INetworkNode node = ((TileNode)tile).getNode();
        if (node instanceof ICoverable && (cover2 = ((ICoverable)((Object)node)).getCoverManager().getCover(direction)) != null && cover2.getType() != CoverType.HOLLOW) {
            return false;
        }
        TileEntity otherTile = world.func_175625_s(pos.func_177972_a(direction));
        if (otherTile instanceof TileNode && ((TileNode)otherTile).getNode() instanceof ICoverable && (cover = ((ICoverable)((Object)((TileNode)otherTile).getNode())).getCoverManager().getCover(direction.func_176734_d())) != null && cover.getType() != CoverType.HOLLOW) {
            return false;
        }
        if (otherTile != null && otherTile.hasCapability(CapabilityNetworkNodeProxy.NETWORK_NODE_PROXY_CAPABILITY, direction.func_176734_d())) {
            return block.getDirection() == null || ((TileBase)tile).getDirection() != direction;
        }
        return false;
    }

    @Override
    public List<CollisionGroup> getCollisions(TileEntity tile, IBlockState state) {
        List<CollisionGroup> groups = this.getCoverCollisions(tile);
        groups.add(ConstantsCable.CORE);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            groups.add(ConstantsCable.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            groups.add(ConstantsCable.EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            groups.add(ConstantsCable.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            groups.add(ConstantsCable.WEST);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            groups.add(ConstantsCable.UP);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            groups.add(ConstantsCable.DOWN);
        }
        return groups;
    }

    private List<CollisionGroup> getCoverCollisions(TileEntity tile) {
        ArrayList<CollisionGroup> groups = new ArrayList<CollisionGroup>();
        if (tile instanceof TileNode && ((TileNode)tile).getNode() instanceof ICoverable) {
            CoverManager coverManager = ((ICoverable)((Object)((TileNode)tile).getNode())).getCoverManager();
            Cover coverNorth = coverManager.getCover(EnumFacing.NORTH);
            Cover coverEast = coverManager.getCover(EnumFacing.EAST);
            Cover coverSouth = coverManager.getCover(EnumFacing.SOUTH);
            Cover coverWest = coverManager.getCover(EnumFacing.WEST);
            Cover coverUp = coverManager.getCover(EnumFacing.UP);
            Cover coverDown = coverManager.getCover(EnumFacing.DOWN);
            if (coverNorth != null) {
                groups.add(new CollisionGroup().addItem(CollisionUtils.getBounds(coverWest != null ? 2 : 0, coverDown != null ? 2 : 0, 0, coverEast != null ? 14 : 16, coverUp != null ? 14 : 16, 2)).setDirection(EnumFacing.NORTH));
                if (coverNorth.getType() != CoverType.HOLLOW) {
                    groups.add(ConstantsCable.HOLDER_NORTH);
                }
            }
            if (coverEast != null) {
                groups.add(new CollisionGroup().addItem(CollisionUtils.getBounds(14, coverDown != null ? 2 : 0, 0, 16, coverUp != null ? 14 : 16, 16)).setDirection(EnumFacing.EAST));
                if (coverEast.getType() != CoverType.HOLLOW) {
                    groups.add(ConstantsCable.HOLDER_EAST);
                }
            }
            if (coverSouth != null) {
                groups.add(new CollisionGroup().addItem(CollisionUtils.getBounds(coverEast != null ? 14 : 16, coverDown != null ? 2 : 0, 16, coverWest != null ? 2 : 0, coverUp != null ? 14 : 16, 14)).setDirection(EnumFacing.SOUTH));
                if (coverSouth.getType() != CoverType.HOLLOW) {
                    groups.add(ConstantsCable.HOLDER_SOUTH);
                }
            }
            if (coverWest != null) {
                groups.add(new CollisionGroup().addItem(CollisionUtils.getBounds(0, coverDown != null ? 2 : 0, 0, 2, coverUp != null ? 14 : 16, 16)).setDirection(EnumFacing.WEST));
                if (coverWest.getType() != CoverType.HOLLOW) {
                    groups.add(ConstantsCable.HOLDER_WEST);
                }
            }
            if (coverUp != null) {
                groups.add(new CollisionGroup().addItem(CollisionUtils.getBounds(0, 14, 0, 16, 16, 16)).setDirection(EnumFacing.UP));
                if (coverUp.getType() != CoverType.HOLLOW) {
                    groups.add(ConstantsCable.HOLDER_UP);
                }
            }
            if (coverDown != null) {
                groups.add(new CollisionGroup().addItem(CollisionUtils.getBounds(0, 0, 0, 16, 2, 16)).setDirection(EnumFacing.DOWN));
                if (coverDown.getType() != CoverType.HOLLOW) {
                    groups.add(ConstantsCable.HOLDER_DOWN);
                }
            }
        }
        return groups;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase entity) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, entity);
        if (this.getDirection() != null) {
            return state.func_177226_a((IProperty)this.getDirection().getProperty(), (Comparable)this.getDirection().getFrom(facing, pos, entity));
        }
        return state;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

